# Channel Sounding Proximity Mac Unlock Demo

A demonstration of Bluetooth LE Channel Sounding for proximity-based Mac lock/unlock. Uses distance measurements from a Silicon Labs CS dev kit to automatically lock your Mac when you walk away and unlock it when you return.

## Quick Start

```bash
# 1. Extract and setup
unzip CS_Proximity_Unlock.zip -d CS_Proximity_Unlock
cd CS_Proximity_Unlock
python3 -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt

# 2. Grant Accessibility permissions (see Setup section below)

# 3. Store your Mac password
python cs_proximity_unlock.py --setup

# 4. Find your serial port
python cs_proximity_unlock.py --list

# 5. Run (replace with your port from step 4)
python cs_proximity_unlock.py /dev/cu.usbmodemXXXX
```

## Features

- **Color-coded UI** with elegant terminal output
- **Real-time distance visualization** with green/yellow/red proximity zones
- **Password safety checks** to prevent typing into wrong windows
- **Fast unlock** (~2 seconds with security maintained)
- **SOC reset detection** - handles device resets gracefully
- **Hysteresis** - prevents lock/unlock flapping

## Hardware Requirements

- Silicon Labs EFR32 dev kit with Channel Sounding firmware (initiator mode)
- Pixel Watch or other Bluetooth LE device with CS reflector capability
- Mac with USB connection to dev kit

## Software Requirements

```bash
# Using pip
pip install -r requirements.txt

# Or using uv
uv venv && uv pip install -r requirements.txt
```

## Setup

### 1. Grant Accessibility Permissions

The app needs to simulate keyboard input to type your password:

1. Open **System Preferences → Privacy & Security → Accessibility**
2. Add and enable your Terminal app (or IDE if running from there)

### 2. Store Your Password

```bash
python cs_proximity_unlock.py --setup
```

This securely stores your Mac password in the macOS Keychain.

### 3. Find Your Serial Port

```bash
python cs_proximity_unlock.py --list
```

Look for a Silicon Labs J-Link device (e.g., `/dev/cu.usbmodem0004403490281`).

## Usage

```bash
# Activate virtual environment first
source .venv/bin/activate

# Full mode (lock + unlock)
python cs_proximity_unlock.py /dev/cu.usbmodem14101

# Lock only (no auto-unlock, no password needed)
python cs_proximity_unlock.py /dev/cu.usbmodem14101 --lock-only

# Unlock only (no auto-lock)
python cs_proximity_unlock.py /dev/cu.usbmodem14101 --unlock-only
```

### What You'll See

```
────────────────────────────────────────────────────
  ◉  Channel Sounding Proximity Unlock
────────────────────────────────────────────────────

  Mode:      Lock + Unlock
  Port:      /dev/cu.usbmodem0004403490281
  Unlock:    < 0.8m
  Lock:      > 2.0m

────────────────────────────────────────────────────
  Waiting for device...

  📱 Connected: 5F:CE:04:1C:12:79

   0.24m (avg: 0.26m)  [████████░░░░░░░░░░░░░░░░░░░░░░]  ●●●
```

- **Distance**: Current (bold, color-coded) and smoothed average
- **Bar**: Color zones - green (near), yellow (mid), red (far)
- **Confidence**: ●●● high, ●●○ medium, ●○○ low

### Events

| Event | Display |
|-------|---------|
| Device connected | `📱 Connected: AA:BB:CC:DD:EE:FF` |
| Device disconnected | `📱 Disconnected` → locks Mac |
| SOC reset | `◉ SOC Reset detected` → locks Mac |
| Screen locked | `🔒 Screen Locked` |
| Screen unlocked | `🔓 Screen Unlocked` |

### Default Thresholds

| Threshold | Distance | Behavior |
|-----------|----------|----------|
| Unlock | < 800mm | Unlock after 3 consecutive readings |
| Lock | > 2000mm | Lock after 5 consecutive readings |

Edit the constants at the top of the script to customize.

## How It Works

1. **Serial Parser**: Reads CS measurements from the dev kit
2. **Likelihood Filter**: Ignores low-confidence measurements (< 0.45)
3. **Smoothing**: Moving average of last 5 readings
4. **Hysteresis**: Requires consecutive readings to prevent flapping
5. **Safety Check**: Verifies lock screen is active before typing password
6. **Lock**: Uses `CGSession -suspend` (native macOS)
7. **Unlock**: Wakes display + types password via Quartz CGEvent APIs

## Commands

| Command | Description |
|---------|-------------|
| `--setup` | Store password in Keychain |
| `--list` | List available serial ports |
| `--lock-only` | Only enable auto-lock (disable unlock) |
| `--unlock-only` | Only enable auto-unlock (disable lock) |
| `--baud RATE` | Set baud rate (default: 115200) |
| `--delete-password` | Remove stored password |
| `--test-lock` | Test the lock function |
| `--test-unlock` | Test the unlock function |

## Security Features

- **Password stored in macOS Keychain** (encrypted)
- **Safety checks before typing**: Verifies login window is active
- **Locks on disconnect/reset**: Mac locks if connection is lost or SOC resets

## Troubleshooting

### "Not authorized to send Apple events to System Events"

Grant Accessibility permissions to your terminal app.

### Screen doesn't unlock

1. Check password is correct: `--delete-password` then `--setup` again
2. Ensure screen is actually locked (not just display off)
3. Try `--test-unlock` to debug

### Safety check fails repeatedly

The app checks that the login window is active before typing your password. If this keeps failing:
- Ensure your screen is actually locked
- Wait for the display to fully wake before the app attempts unlock

### Measurements not showing

- Check serial port is correct
- Verify dev kit firmware is running
- Ensure reflector device is connected and in range

## Architecture

```
┌─────────────────┐     Serial      ┌──────────────────┐
│  Silicon Labs   │────────────────▶│  Python Script   │
│  CS Dev Kit     │   Distance +    │                  │
│  (Initiator)    │   Likelihood    │  ┌────────────┐  │
└─────────────────┘                 │  │  Parser    │  │
        ▲                           │  └─────┬──────┘  │
        │ Bluetooth LE              │        │         │
        │ Channel Sounding          │  ┌─────▼──────┐  │
┌───────┴─────────┐                 │  │ Processor  │  │
│   Pixel Watch   │                 │  │ (smooth +  │  │
│   (Reflector)   │                 │  │ hysteresis)│  │
└─────────────────┘                 │  └─────┬──────┘  │
                                    │        │         │
                                    │  ┌─────▼──────┐  │
                                    │  │   macOS    │  │
                                    │  │ Controller │  │
                                    │  └────────────┘  │
                                    └──────────────────┘
                                             │
                                             ▼
                                    Lock: CGSession -suspend
                                    Unlock: Quartz CGEvent APIs
```

## Demo/Educational Use Only

This stores your Mac password in Keychain and types it programmatically. Use only for demos and personal experimentation, not production security.

## License

MIT - For educational and demo purposes.

---

*Part of Novel Bits Channel Sounding educational content*
