#!/bin/bash
# Auto-detect Silicon Labs dev kit and launch CS Proximity Unlock
# Usage: ./run.sh [additional arguments for cs_proximity_unlock.py]

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
PYTHON_SCRIPT="$SCRIPT_DIR/cs_proximity_unlock.py"

# Use the project's virtual environment automatically
if [[ -f "$SCRIPT_DIR/.venv/bin/python3" ]]; then
    PYTHON="$SCRIPT_DIR/.venv/bin/python3"
elif [[ -f "$SCRIPT_DIR/venv/bin/python3" ]]; then
    PYTHON="$SCRIPT_DIR/venv/bin/python3"
else
    echo "Error: No virtual environment found."
    echo "Run: python3 -m venv .venv && .venv/bin/pip install -r requirements.txt"
    exit 1
fi

# Find all usbmodem ports
ports=(/dev/cu.usbmodem*)

# Check if glob matched anything
if [[ "${ports[0]}" == "/dev/cu.usbmodem*" ]]; then
    echo "Error: No USB modem devices found."
    echo "Make sure the Silicon Labs dev kit is plugged in."
    exit 1
fi

if [[ ${#ports[@]} -eq 1 ]]; then
    port="${ports[0]}"
    echo "Found device: $port"
else
    # Multiple ports - try to find the Silicon Labs J-Link
    silabs_port=""
    for p in "${ports[@]}"; do
        if ioreg -p IOUSB -l 2>/dev/null | grep -q "Silicon Labs"; then
            silabs_port="$p"
            break
        fi
    done

    if [[ -n "$silabs_port" ]]; then
        port="$silabs_port"
        echo "Found Silicon Labs device: $port"
    else
        echo "Multiple USB modem devices found:"
        for i in "${!ports[@]}"; do
            echo "  [$((i+1))] ${ports[$i]}"
        done
        printf "Select port [1]: "
        read -r choice
        choice=${choice:-1}
        port="${ports[$((choice-1))]}"
    fi
fi

echo "Starting CS Proximity Unlock on $port..."
echo ""
"$PYTHON" "$PYTHON_SCRIPT" "$port" "$@"
