# CS Ranging Watch App

A minimal Wear OS application for Bluetooth LE Channel Sounding (CS) ranging with Silicon Labs SoC devices.

## Overview

This app operates as a **BLE Central** that connects to a Silicon Labs SoC running as a **Peripheral + CS Initiator**. The watch simply establishes a BLE connection - all Channel Sounding procedures are initiated and controlled by the SoC.

### Architecture

```
┌─────────────────────────────────────────────────────────────────────────┐
│                          SYSTEM ARCHITECTURE                            │
├─────────────────────────────────────────────────────────────────────────┤
│                                                                         │
│   ┌─────────────────────┐              ┌─────────────────────────────┐  │
│   │    WATCH (This App) │              │    Silicon Labs SoC         │  │
│   │                     │              │                             │  │
│   │   ┌─────────────┐   │    BLE       │   ┌─────────────────────┐   │  │
│   │   │ BLE Central │◄──┼──────────────┼──►│   BLE Peripheral    │   │  │
│   │   └─────────────┘   │  Connection  │   └─────────────────────┘   │  │
│   │                     │              │                             │  │
│   │   ┌─────────────┐   │     CS       │   ┌─────────────────────┐   │  │
│   │   │CS Responder │◄──┼──────────────┼───│   CS Initiator      │   │  │
│   │   └─────────────┘   │  Procedures  │   └─────────────────────┘   │  │
│   │                     │              │             │               │  │
│   └─────────────────────┘              │   ┌─────────▼───────────┐   │  │
│                                        │   │ Distance Calculator │   │  │
│                                        │   └─────────────────────┘   │  │
│                                        │             │               │  │
│                                        │   ┌─────────▼───────────┐   │  │
│                                        │   │   Console Output    │   │  │
│                                        │   │  (Measurements)     │   │  │
│                                        │   └─────────────────────┘   │  │
│                                        └─────────────────────────────┘  │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
```

### Roles Explained

| Component | BLE Role | CS Role | Responsibility |
|-----------|----------|---------|----------------|
| Watch App | Central (scans, connects) | Responder | Establish connection, respond to CS |
| SoC | Peripheral (advertises) | Initiator | Advertise, initiate CS, calculate distance |

## How It Works

### Connection Flow

```
┌───────────────────────────────────────────────────────────────────────┐
│                        CONNECTION FLOW                                │
├───────────────────────────────────────────────────────────────────────┤
│                                                                       │
│  WATCH                                           SoC                  │
│    │                                              │                   │
│    │  1. User taps screen                         │                   │
│    ├─────────────────────────────────────────────►│                   │
│    │                                              │                   │
│    │  2. BLE Scan (looking for target devices)    │                   │
│    │◄─────────────────────────────────────────────┤ Advertising       │
│    │                                              │                   │
│    │  3. Found device, initiate pairing           │                   │
│    ├─────────────────────────────────────────────►│                   │
│    │                                              │                   │
│    │  4. Pairing/Bonding handshake               │                   │
│    │◄────────────────────────────────────────────►│                   │
│    │                                              │                   │
│    │  5. GATT Connect                             │                   │
│    ├─────────────────────────────────────────────►│                   │
│    │                                              │                   │
│    │  6. MTU Exchange (512 bytes)                 │                   │
│    │◄────────────────────────────────────────────►│                   │
│    │                                              │                   │
│    │  7. Service Discovery                        │                   │
│    │◄─────────────────────────────────────────────┤                   │
│    │                                              │                   │
│    │  8. CS Procedures (SoC initiated)            │                   │
│    │◄────────────────────────────────────────────►│                   │
│    │                                              │                   │
│    │  9. Distance measurements printed            │                   │
│    │                                              ├───► Console       │
│    │                                              │                   │
└───────────────────────────────────────────────────────────────────────┘
```

### State Machine

```
┌─────────────────────────────────────────────────────────────────┐
│                      APP STATE MACHINE                          │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│                        ┌──────────┐                             │
│              ┌─────────│   IDLE   │◄────────────┐               │
│              │         └────┬─────┘             │               │
│              │              │                   │               │
│              │         User taps screen         │               │
│              │              │                   │               │
│              │              ▼                   │               │
│              │         ┌──────────┐             │               │
│   Scan failed│         │ SCANNING │             │ Disconnected  │
│              │         └────┬─────┘             │               │
│              │              │                   │               │
│              │         Device found             │               │
│              │              │                   │               │
│              │              ▼                   │               │
│              │       ┌────────────┐             │               │
│              └───────│ CONNECTING │─────────────┘               │
│                      └─────┬──────┘                             │
│                            │                                    │
│                      GATT connected                             │
│                            │                                    │
│                            ▼                                    │
│                      ┌───────────┐                              │
│                      │ CONNECTED │──────┐                       │
│                      └───────────┘      │                       │
│                            ▲            │ User taps             │
│                            │            │ (disconnect)          │
│                            └────────────┘                       │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

### UI States

| State | Screen Color | Text | User Action |
|-------|--------------|------|-------------|
| IDLE | Dark Gray (#1a1a1a) | "TAP TO START" | Tap to scan |
| SCANNING | Blue (#1565C0) | "SCANNING..." | Wait |
| CONNECTING | Dark Blue (#0D47A1) | "CONNECTING..." | Wait |
| CONNECTED | Green (#2E7D32) | "CONNECTED" | Tap to disconnect |

## Technical Details

### Target Device

The app scans for a device with the name: `CS_INIT_SOC`

### Pairing Behavior

The app handles two pairing scenarios:

1. **With Bonding (ALLOW_BONDING=1 on SoC)**:
   - Bond state: `NONE` → `BONDING` → `BONDED`
   - GATT connection after `BONDED` state

2. **Without Bonding (ALLOW_BONDING=0 on SoC)**:
   - Bond state: `NONE` → `BONDING` → `NONE`
   - Pairing establishes encryption but keys aren't stored
   - GATT connection after 500ms delay (to allow encryption to settle)

### Required Permissions

```xml
<uses-permission android:name="android.permission.BLUETOOTH_CONNECT" />
<uses-permission android:name="android.permission.BLUETOOTH_SCAN" />
<uses-permission android:name="android.permission.ACCESS_FINE_LOCATION" />
```

### Key Parameters

| Parameter | Value | Purpose |
|-----------|-------|---------|
| Scan Mode | LOW_LATENCY | Fast device discovery |
| MTU | 512 bytes | Large data transfer capability |
| Transport | LE | Bluetooth Low Energy only |
| Post-pairing delay | 500ms | Allow encryption to settle |

## Building and Installing

### Prerequisites

- Android Studio with Wear OS SDK
- ADB configured for wireless debugging
- Watch with Developer Options enabled

### Build

```bash
# Set Java home (if needed)
export JAVA_HOME="/Applications/Android Studio.app/Contents/jbr/Contents/Home"

# Build debug APK
./gradlew assembleDebug
```

### Install

```bash
# Connect to watch (replace IP and port)
adb connect <watch-ip>:<port>

# Install APK
adb install -r -t app/build/outputs/apk/debug/app-debug.apk
```

### Wireless Debugging Setup

1. On watch: Settings → Developer options → Wireless debugging → Enable
2. Note the IP address and port shown
3. Connect via ADB: `adb connect <ip>:<port>`

## File Structure

```
CS_RangingWatchApp/
├── app/
│   ├── src/main/
│   │   ├── java/com/novelbits/csrangingwatch/
│   │   │   └── MainActivity.java      # Main (and only) activity
│   │   ├── res/
│   │   │   └── layout/
│   │   │       └── activity_main.xml  # Simple full-screen layout
│   │   └── AndroidManifest.xml
│   └── build.gradle.kts
├── gradle/
├── build.gradle.kts
├── settings.gradle.kts
└── README.md
```

## Usage with Silicon Labs SoC

### SoC Configuration

The companion SoC should be running `bt_cs_soc_peripheral_initiator` with:

- **BLE Role**: Peripheral (advertises, accepts connections)
- **CS Role**: Initiator (starts CS procedures, calculates distance)
- **Antenna Config**: Single antenna (1:1) for watch compatibility

### Typical Session

1. Power on SoC - it starts advertising
2. Launch watch app - shows "TAP TO START"
3. Tap screen - watch scans and connects
4. Screen turns green when connected
5. SoC console shows distance measurements
6. Tap screen again to disconnect

## Compatibility

### Tested Devices

- **Watch**: Samsung Galaxy Watch (Wear OS with CS support)
- **SoC**: Silicon Labs xG24 with bt_cs_soc_peripheral_initiator

### Requirements

- Wear OS with Bluetooth LE Channel Sounding support
- Android API level compatible with `android.ranging.*` APIs
- Watch must support CS Responder role

## Troubleshooting

### Connection Issues

| Symptom | Possible Cause | Solution |
|---------|----------------|----------|
| Stuck on SCANNING | SoC not advertising | Restart SoC |
| Stuck on CONNECTING | Stale bond info | Clear bond on both devices |
| Immediate disconnect | Capability mismatch | Check SoC antenna config |

### Clearing Bond Information

**On Watch:**
Settings → Bluetooth → Paired devices → Forget device

**On SoC:**
Restart the device (bonds are typically not persisted with ALLOW_BONDING=0)

---

## Version History

| Version | Description |
|---------|-------------|
| v1.0 | Initial: Full debug UI with two-phase flow |
| v2.0 | Minimal: Single-tap UI, removed ranging code |

See [CHANGELOG.md](CHANGELOG.md) for detailed changes.
