plugins {
  alias(libs.plugins.androidApplication)
}

android {
  namespace = "com.novelbits.csrangingwatch"
  compileSdkVersion = "android-Baklava"

  defaultConfig {
    applicationId = "com.novelbits.csrangingwatch"
    minSdk = 35
    targetSdk = 35
    versionCode = 1
    versionName = "1.0"

    testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
  }

  signingConfigs {
    create("config") {
      storeFile = file("com.android.ranging.rangingtestapp.keystore")
      storePassword =  "RangingTestApp"
      keyAlias = "com.android.ranging.rangingtestapp"
      keyPassword = "RangingTestApp"
    }
  }

  buildTypes {
    release {
      isMinifyEnabled = false
      proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
      signingConfig = signingConfigs.findByName("config")
    }
    debug {
      isMinifyEnabled = false
      proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
      signingConfig = signingConfigs.findByName("config")
    }
  }
  compileOptions {
    sourceCompatibility = JavaVersion.VERSION_1_8
    targetCompatibility = JavaVersion.VERSION_1_8
  }
  buildFeatures {
    viewBinding = true
  }
  buildToolsVersion = "35.0.0"
}

dependencies {

  implementation(libs.appcompat)
  implementation(libs.material)
  implementation(libs.constraintlayout)
  implementation(libs.navigation.fragment)
  implementation(libs.navigation.ui)
  implementation(libs.legacy.support.v4)
  implementation(libs.lifecycle.livedata.ktx)
  implementation(libs.lifecycle.viewmodel.ktx)
  // Wear OS
  implementation("androidx.wear:wear:1.3.0")
  testImplementation(libs.junit)
  androidTestImplementation(libs.ext.junit)
  androidTestImplementation(libs.espresso.core)
}
